//

// Fragment shader for replace one color with another
// typical use would be to remove a color by replacing
// it with a color with a low or zero alpha value
//
// Author: Jeff Brown
//
uniform sampler2DRect texUnit;
uniform vec4 keyColor;
uniform float tolerance;
uniform vec4 textureRect;
varying vec2 gUV;


void main(void)
{
    if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else
    {
        vec4 outputColor = texture2DRect(texUnit, gUV);
        vec3 diff=abs(outputColor.rgb-keyColor.rgb);
        if(diff.r<tolerance)
        {
            if(diff.g<tolerance)
            {
                if(diff.b<tolerance)
                {
                    outputColor.a=0.0;//(diff.r+diff.b+diff.g)*.3;
                }
            }
        }
        gl_FragColor = outputColor;
    }
}


